<?php
/* --------------------------------------------------------------
 Configuration.php 2020-03-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Write;

/**
 * Class Configuration
 * @package Gambio\Core\Configuration\Models\Write
 */
class Configuration implements Interfaces\Configuration, Interfaces\GeneralConfiguration
{
    /**
     * @var string
     */
    private $key;
    
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * Configuration constructor.
     *
     * @param string $key
     * @param string $value
     */
    private function __construct(string $key, string $value)
    {
        $this->key   = $key;
        $this->value = $value;
    }
    
    
    /**
     * Factory method to create Configuration.
     *
     * @param string $key
     * @param string $value
     *
     * @return static
     */
    public static function create(string $key, string $value): self
    {
        return new static($key, $value);
    }
    
    
    /**
     * Factory method to create a list of Configuration's.
     *
     * @param array $data
     *
     * @return self[]
     */
    public static function bulkCreate(array $data): array
    {
        $configurations = [];
        
        foreach ($data as $key => $value) {
            $configurations[] = self::create($key, $value);
        }
        
        return $configurations;
    }
    
    
    /**
     * @inheritDoc
     */
    public function key(): string
    {
        return $this->key;
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): string
    {
        return $this->value;
    }
}